/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.filesystem;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import jemu.core.device.filesystem.DskMaster;

public class DskSector {
    DskMaster master;
    int trackC;
    int sideH = 0;
    int sectorIdR;
    int sectorSizeN = 2;
    int fdc1;
    int fdc2;
    public byte[] data = null;
    long dataPosition = 0L;

    public int getSectorSize() {
        return this.master.sectorSizes[this.sectorSizeN];
    }

    public DskSector(DskMaster master) {
        this.master = master;
    }

    public DskSector(DskSector sector) {
        this.master = sector.master;
        this.trackC = sector.trackC;
        this.sideH = sector.sideH;
        this.sectorIdR = sector.sectorIdR;
        this.sectorSizeN = sector.sectorSizeN;
        this.data = sector.data;
        this.dataPosition = sector.dataPosition;
    }

    public void scan(FileInputStream fis) throws IOException {
        this.trackC = fis.read();
        this.sideH = fis.read();
        this.sectorIdR = fis.read();
        this.sectorSizeN = fis.read();
        this.fdc1 = fis.read();
        this.fdc2 = fis.read();
        fis.read();
        fis.read();
    }

    public void scan(FileOutputStream fos) throws IOException {
        fos.write(this.trackC);
        fos.write(this.sideH);
        fos.write(this.sectorIdR);
        fos.write(this.sectorSizeN);
        fos.write(this.fdc1);
        fos.write(this.fdc2);
        fos.write(0);
        fos.write(2);
    }

    public void scanData(FileOutputStream fos) throws IOException {
        this.dataPosition = fos.getChannel().position();
        if (this.data == null) {
            this.data = new byte[this.master.sectorSizes[this.sectorSizeN]];
        }
        fos.write(this.data);
    }

    public void scanData(RandomAccessFile fos) throws IOException {
        fos.getChannel().position(this.dataPosition);
        if (this.data == null) {
            this.data = new byte[this.master.sectorSizes[this.sectorSizeN]];
        }
        fos.write(this.data);
        if (this.data.length < this.master.sectorSizes[this.sectorSizeN] - 2) {
            fos.write(26);
            fos.write(0);
        } else if (this.data.length < this.master.sectorSizes[this.sectorSizeN] - 1) {
            fos.write(0);
        }
    }

    public void scanData(FileInputStream fis) throws IOException {
        this.dataPosition = fis.getChannel().position();
        if (this.data == null) {
            this.data = new byte[this.master.sectorSizes[this.sectorSizeN]];
        }
        fis.read(this.data);
    }

    public String toString() {
        return "track " + this.trackC + " head " + this.sideH + " id:" + String.format("#%02X", this.sectorIdR) + "\n" + this.data.length + " position " + this.dataPosition + "\n";
    }
}

